-- Selection Manager
-- load the static definitions
require("scripts/selection scripts/SelectionDefines.lua");

globalEntryIndex = 0;

SelectionManager = nil;
SelectionManager = {};
SelectionManager.__index = SelectionManager;

function SelectionManager.create()
	local mgr = {}
	setmetatable(mgr, SelectionManager)
	mgr.selections = {};

	return mgr;
end

function SelectionManager:CopyEntry(mastertable,option_entry)
	option_entry[1]= mastertable[1];
	option_entry[2]= mastertable[2];
	option_entry[3]= mastertable[3];
end


function SelectionManager:AddOption(baseType, subType, flavorText, isValid)
	option_entry = {}

	-- Lua has a base array value of 1, not 0 (sub type is a C style enum)
	base_index = tonumber(baseType) + 1;
	entry_index = tonumber(subType) + 1;

	-- Check the base type
	if baseType == SelectionType.APPETIZER then
			self:CopyEntry(AppetizerEntries[entry_index],option_entry);
	elseif baseType == SelectionType.MEAL then
			self:CopyEntry(MealEntries[entry_index],option_entry);
	elseif baseType == SelectionType.CAKE then
			self:CopyEntry(CakeEntries[entry_index],option_entry);
	elseif baseType == SelectionType.FLOWERS then
			self:CopyEntry(FlowerEntries[entry_index],option_entry);
	elseif baseType == SelectionType.HONEYMOON then
			self:CopyEntry(HoneymoonEntries[entry_index],option_entry);
	elseif baseType == SelectionType.COLOR then
			self:CopyEntry(ColorEntries[entry_index],option_entry);
	end

	-- insert the flavor text
	if option_entry[4] == nil then
	    table.insert(option_entry, flavorText);
    else
        option_entry[4]= flavorText;
    end
        
	-- Figure out whether or not this option is a "valid" selection
	v = 0;
	if isValid == true then
	    v = 1;
		--table.insert(option_entry, 1);
	--else
		--table.insert(option_entry, 0);
	end
    
    if option_entry[5] == nil then
        table.insert(option_entry, v);
    else
        option_entry[5] = v;
    end
    
	-- insert the new option into the selection list
	if(self.selections[base_index] == nil) then
		self.selections[base_index] = {}
	end

	table.insert(self.selections[base_index], option_entry);

end

function SelectionManager:AddAppetizer(type, flavorText, isValid)
	self:AddOption(SelectionType.APPETIZER, type, flavorText, isValid);
end

function SelectionManager:AddMeal(type, flavorText, isValid)
	self:AddOption(SelectionType.MEAL, type, flavorText, isValid);
end

function SelectionManager:AddCake(type, flavorText, isValid)
	self:AddOption(SelectionType.CAKE, type, flavorText, isValid);
end

function SelectionManager:AddFlowers(type, flavorText, isValid)
	self:AddOption(SelectionType.FLOWERS, type, flavorText, isValid);
end

function SelectionManager:AddHoneymoon(type, flavorText, isValid)
	self:AddOption(SelectionType.HONEYMOON, type, flavorText, isValid);
end

function SelectionManager:AddColor(type, flavorText, isValid)
	self:AddOption(SelectionType.COLOR, type, flavorText, isValid);
end

function SelectionManager:GenerateSelection(selectionType1, selectionType2, selectionType3)
	selection_list = {};

	
	-- Add Core Data
	table.insert(selection_list, self.selections[tonumber(selectionType1)+1]);
	table.insert(selection_list, self.selections[tonumber(selectionType2)+1]);
	table.insert(selection_list, self.selections[tonumber(selectionType3)+1]);

	-- Add Type Flags
	selection_list[1].type=selectionType1;
	selection_list[2].type=selectionType2;
	selection_list[3].type=selectionType3;

	-- Return the new list
	return selection_list;
end